function getProvince(provinceText, cityText, countryText, codeText, countryCode, otherText) { 
	if(typeof provinceText != 'object'){
		provinceText = $("#" + provinceText); 
	}
	if(typeof cityText != 'object'){
		cityText = $("#" + cityText);
	}
	if(typeof countryText != 'object'){
		countryText = $("#" + countryText);
	}
	if(typeof codeText != 'object'){
		codeText = $("#" + codeText);
	}
	if(typeof countryCode != 'object'){
		countryCode = $("#" + countryCode);
	}
	var countryCodeValue = countryCode.val();
	
	// ֤countryCodeЧ
	if(countryCodeValue.length < 12) { 
		for(i = 0; i< 12 - countryCodeValue.length; i++) { 
			countryCodeValue += "0"; 
		} 
	}

	// 󶨺
	provinceText.change(function(){
		if($(this).val() != " "){
			getCity(provinceText, cityText, countryText, codeText, $(this).val());
			countryCode.val($(this).val());
		}else{
			$("#" + otherText).show();
			cityText.val("");
			countryText.attr("disabled","disabled").val("");
			provinceText.parent().hide();
		}
	});
	cityText.change(function(){
		getCountry(provinceText, cityText, countryText, $(this).val());
		
		var codeValue = Code[$(this).val()];
		if (codeText) {
			if(codeValue === undefined){
				codeText.removeAttr("disabled");
				codeText.val("");
			}else{
				codeText.removeAttr("disabled");
				codeText.val(Code[$(this).val()]);
			}
		}
		if($(this).val() != ''){
			countryCode.val($(this).val());
		}else{
			countryCode.val(provinceText.val());
		}
	});
	countryText.change(function(){
		if($(this).val() != ''){
			countryCode.val($(this).val());
		}else{
			countryCode.val(cityText.val());
		}
	});

	// Ĭ
	cityText.empty();
	cityText.append("<option value=''></option>"); 
	cityText.attr("disabled","disabled");
	countryText.empty();
	countryText.append("<option value=''></option>"); 
	countryText.attr("disabled","disabled");

	if(Province.length > 0) {
		provinceText.empty();
		provinceText.append("<option value=''>ʡ</option>"); 
		for(i = 0; i < Province.length; i += 2) { 
			if(Province[i] == '' || Province[i+1] == '') {
				continue; 
			} else { 
				var selected = "";
				if(countryCodeValue.substring(0, 6) == Province[i]){
					selected = "selected";
				}
				provinceText.append("<option value='"+Province[i]+"' " + selected + ">"+Province[i+1]+"</option>");
			}
		}
		if(otherText && $("#" + otherText).size() > 0){
			provinceText.append("<option value=' ' ></option>");
		}
	}

	getCity(provinceText, cityText, countryText, codeText, countryCodeValue.substring(0, 9));
	getCountry(provinceText, cityText, countryText, countryCodeValue.substring(0, 12)); 
	
	if (codeText) {
		if(cityText.val() > 0){
			codeText.val(Code[cityText.val()]);
		}
	}
}

/**
 * ó
 * @param provinceText jquery
 * @param cityText jquery
 * @param countryText jquery
 */	
function getCity(provinceText, cityText, countryText, codeText, value){ 
	var provinceCode = provinceText.val();
	
	cityText.removeAttr("disabled");
	cityText.empty();
	cityText.append("<option value=''></option>");
	countryText.empty();
	countryText.append("<option value=''></option>"); 
	countryText.attr("disabled","disabled");
	
	if(provinceCode == ''){
		cityText.attr("disabled","disabled");
		countryText.attr("disabled","disabled");
		return;
	}
	
	for(i = 0; i < City[provinceCode].length; i += 2){
		if(City[provinceCode][i] == "" || City[provinceCode][i+1] == ""){
			continue; 
		}else{
			var selected = "";
			if(value == City[provinceCode][i]){
				selected = "selected";
			}
			cityText.append("<option value='"+City[provinceCode][i]+"' " + selected + ">"+City[provinceCode][i+1]+"</option>"); 
		}
	}
}

/**
 * õ
 * @param provinceText jquery
 * @param cityText jquery
 * @param countryText jquery
 */		
function getCountry(provinceText, cityText, countryText, value){
	var provinceCode = provinceText.val();
	var cityCode = cityText.val();

	countryText.removeAttr("disabled");
	countryText.empty();
	countryText.append("<option value=''></option>"); 
	
	if(provinceCode == '' || cityCode == ''){
		countryText.attr("disabled","disabled");
		return;
	}
	for(i = 0; i < County[cityCode].length; i += 2){
		if(County[cityCode][i] == "" || County[cityCode][i+1] == ""){ 
			continue; 
		} else { 
			var selected = "";
			if(value == County[cityCode][i]){
				selected = "selected";
			}
			countryText.append("<option value='"+County[cityCode][i]+"' " + selected + ">"+County[cityCode][i+1]+"</option>");
		} 
	}
}

var Province = new Array('101101','','101102','','101103','ӱʡ','101104','ɽʡ','101105','ɹ','102101','ʡ','102102','ʡ','102103','ʡ','103101','Ϻ','103102','ʡ','103103','㽭ʡ','103104','ʡ','103105','ʡ','103106','ʡ','103107','ɽʡ','104101','ʡ','104102','ʡ','104103','ʡ','104104','㶫ʡ','104105','׳','104106','ʡ','105100','','105101','Ĵʡ','105102','ʡ','105103','ʡ','105104','','106101','ʡ','106102','ʡ','106103','ຣʡ','106104','Ļ','106105','½ά','107101','̨','108101','ر','109101','ر')

var City = new Array()
City["101101"] = new Array('101101000','','101101101','')
City["101102"] = new Array('101102000','','101102101','')
City["101103"] = new Array('101103000','','101103101','ʯׯ','101103102','ɽ','101103103','ػʵ','101103104','','101103105','̨','101103106','','101103107','żҿ','101103108','е','101103109','','101103110','ȷ','101103111','ˮ')
City["101104"] = new Array('101104000','','101104101','̫ԭ','101104102','ͬ','101104103','Ȫ','101104104','','101104105','','101104106','˷','101104107','УܴΣ','101104108','˳ǣκ','101104109','','101104110','ٷ','101104111','ʯ')
City["101105"] = new Array('101105100','','101105101','ͺ','101105102','ͷ','101105103','ں','101105104','','101105105','ͨ','101105106','˹','101105107','ױ','101105108','˰','101105109','ֹ','101105110','첼','101105111','׶','101105112','')
City["102101"] = new Array('102101000','','102101101','','102101102','','102101103','ɽ','102101104','˳','102101105','Ϫ','102101106','','102101107','','102101108','Ӫ','102101109','','102101110','','102101112','̽','102101113','','102101114','','102101115','«')
City["102102"] = new Array('102102000','','102102101','','102102102','','102102103','ƽ','102102104','Դ','102102105','ͨ','102102106','ɽ','102102107','ԭ','102102108','׳','102102109','Ӽ')
City["102103"] = new Array('102103000','','102103101','','102103102','','102103103','','102103104','׸','102103105','˫Ѽɽ','102103106','','102103107','','102103108','ľ˹','102103109','̨','102103110','ĵ','102103111','ں','102103112','绯','102103113','Ӹ')
City["103101"] = new Array('103101100','','103101101','Ϻ')
City["103102"] = new Array('103102100','','103102101','Ͼ','103102102','','103102103','','103102104','','103102105','','103102106','ͨ','103102107','Ƹ','103102108','','103102109','γ','103102110','','103102111','','103102112','̩','103102113','Ǩ')
City["103103"] = new Array('103103000','','103103101','','103103102','','103103103','','103103104','','103103105','','103103106','','103103107','','103103108','','103103109','ɽ','103103110','̨','103103111','ˮ')
City["103104"] = new Array('103104000','','103104101','Ϸ','103104102','ߺ','103104103','','103104104','','103104105','ɽ','103104106','','103104107','ͭ','103104108','','103104109','ɽ','103104110','','103104111','','103104112','','103104113','','103104114','','103104115','','103104116','','103104117','')
City["103105"] = new Array('103105000','','103105101','','103105102','','103105103','','103105104','','103105105','Ȫ','103105106','','103105107','ƽ','103105108','','103105109','')
City["103106"] = new Array('103106000','','103106101','ϲ','103106102','','103106103','Ƽ','103106104','Ž','103106105','','103106106','ӥ̶','103106107','','103106108','','103106109','˴','103106110','','103106111','')
City["103107"] = new Array('103107000','','103107101','','103107102','ൺ','103107103','Ͳ','103107104','ׯ','103107105','Ӫ','103107106','̨','103107107','Ϋ','103107108','','103107109','̩','103107110','','103107111','','103107112','','103107113','','103107114','','103107115','ĳ','103107116','','103107117','')
City["104101"] = new Array('104101000','','104101101','֣','104101102','','104101103','','104101104','ƽɽ','104101105','','104101106','ױ','104101107','','104101108','','104101109','','104101110','','104101111','','104101112','Ͽ','104101113','','104101114','','104101115','','104101116','ܿ','104101117','פ')
City["104102"] = new Array('104102000','','104102101','人','104102102','ʯ','104102103','ʮ','104102105','˲','104102106','差','104102107','','104102108','','104102109','Т','104102110','','104102111','Ƹ','104102112','','104102113','','104102128','ʩ','104102190','ʡֱϽ')
City["104103"] = new Array('104103000','','104103101','ɳ','104103102','','104103103','̶','104103104','','104103105','','104103106','','104103107','','104103108','żҽ','104103109','','104103110','','104103111','','104103112','','104103113','¦','104103131','')
City["104104"] = new Array('104104000','','104104101','','104104102','ع','104104103','','104104104','麣','104104105','ͷ','104104106','ɽ','104104107','','104104108','տ','104104109','ï','104104112','','104104113','','104104114','÷','104104115','β','104104116','Դ','104104117','','104104118','Զ','104104119','ݸ','104104120','ɽ','104104151','','104104152','','104104153','Ƹ')
City["104105"] = new Array('104105000','','104105101','','104105102','','104105103','','104105104','','104105105','','104105106','Ǹ','104105107','','104105108','','104105109','','104105110','ɫ','104105111','','104105112','ӳ','104105113','','104105114','')
City["104106"] = new Array('104106000','','104106101','','104106102','','104106110','ɳ','104106111','','104106112','ֶ','104106113','ˮ','104106114','ͤ','104106115','','104106116','ɳȺ','104106117','ɳȺ','104106118','ɳȺ','104106190','ָɽ','104106191','','104106192','','104106193','Ĳ','104106194','','104106195','','104106196','','104106197','Ͳ','104106198','','104106199','ٸ','104106200','־ÿ')
City["105100"] = new Array('105100000','','105100101','')
City["105101"] = new Array('105101000','','105101101','ɶ','105101103','Թ','105101104','֦','105101105','','105101106','','105101107','','105101108','Ԫ','105101109','','105101110','ڽ','105101111','ɽ','105101113','ϳ','105101114','üɽ','105101115','˱','105101116','㰲','105101117','','105101118','Ű','105101119','','105101120','','105101132','','105101133','','105101134','ɽ')
City["105102"] = new Array('105102000','','105102101','','105102102','ˮ','105102103','','105102104','˳','105102122','ͭʵ','105102123','ǭ','105102124','Ͻڵ','105102126','ǭ','105102127','ǭ')
City["105103"] = new Array('105103000','','105103101','','105103103','','105103104','Ϫ','105103105','ɽ','105103106','ͨ','105103107','','105103123','','105103125','','105103126','ɽ','105103127','˼é','105103128','˫','105103129','','105103131','º','105103133','ŭ','105103134','','105103135','ٲ׵')
City["105104"] = new Array('105104000','','105104101','','105104121','','105104122','ɽϵ','105104123','տ','105104124','','105104125','','105104126','֥')
City["106101"] = new Array('106101000','','106101101','','106101102','ͭ','106101103','','106101104','','106101105','μ','106101106','Ӱ','106101107','','106101108','','106101109','','106101110','')
City["106102"] = new Array('106102000','','106102101','','106102102','','106102103','','106102104','','106102105','ˮ','106102106','','106102107','Ҵ','106102108','ƽ','106102109','Ȫ','106102110','','106102124','','106102126','¤ϵ','106102129','','106102130','')
City["106103"] = new Array('106103000','','106103101','','106103121','','106103122','','106103123','','106103125','','106103126','','106103127','','106103128','')
City["106104"] = new Array('106104000','','106104101','','106104102','ʯɽ','106104103','','106104104','ԭ')
City["106105"] = new Array('106105000','','106105101','³ľ','106105102','','106105121','³','106105122','ܵ','106105123','','106105127','','106105128','','106105129','յ','106105130','','106105131','ʲ','106105132','','106105140','','106105142','ǵ','106105143','̩','106105190','ʡֱϽ')
City["107101"] = new Array('107101000','','107101101','̨')
City["108101"] = new Array('108101101','')
City["109101"] = new Array('109101101','')

var Code = new Array()
Code["101101101"] = '010';
Code["101102101"] = '022';
Code["101103101"] ='0311';Code["101103102"] ='0315';Code["101103103"] ='0335';Code["101103104"] ='0310';Code["101103105"] ='0319';Code["101103106"] ='0312';Code["101103107"] ='0313';Code["101103108"] ='0314';Code["101103109"] ='0317';Code["101103110"] ='0316';Code["101103111"] ='0318';
Code["101104101"] ='0351';Code["101104102"] ='0352';Code["101104103"] ='0353';Code["101104104"] ='0355';Code["101104105"] ='0356';Code["101104106"] ='0349';Code["101104107"] ='0354';Code["101104108"] ='0359';Code["101104109"] ='0350';Code["101104110"] ='0357';Code["101104111"] ='0358';
Code["101105101"] ='0471';Code["101105102"] ='0472';Code["101105103"] ='0473';Code["101105104"] ='0476';Code["101105105"] ='0475';Code["101105106"] ='0477';Code["101105107"] ='0470';Code["101105108"] ='0482';Code["101105109"] ='0479';Code["101105110"] ='0474';Code["101105111"] ='0478';Code["101105112"] ='0483';
Code["102101101"] ='024';Code["102101102"] ='0411';Code["102101103"] ='0412';Code["102101104"] ='0413';Code["102101105"] ='0414';Code["102101106"] ='0415';Code["102101107"] ='0416';Code["102101108"] ='0417';Code["102101109"] ='0418';Code["102101110"] ='0419';Code["102101112"] ='0427';Code["102101113"] ='0410';Code["102101114"] ='0421';Code["102101115"] ='0429';
Code["102102101"] ='0431';Code["102102102"] ='0432';Code["102102103"] ='0434';Code["102102104"] ='0437';Code["102102105"] ='0435';Code["102102106"] ='0439';Code["102102107"] ='0438';Code["102102108"] ='0436';Code["102102109"] ='0433';
Code["102103101"] ='0451';Code["102103102"] ='0452';Code["102103103"] ='0467';Code["102103104"] ='0468';Code["102103105"] ='0469';Code["102103106"] ='0459';Code["102103107"] ='0458';Code["102103108"] ='0454';Code["102103109"] ='0464';Code["102103110"] ='0453';Code["102103111"] ='0456';Code["102103112"] ='0455';Code["102103113"] ='0457';
Code["103101101"] ='021';
Code["103102101"] ='025';Code["103102102"] ='0510';Code["103102103"] ='0516';Code["103102104"] ='0519';Code["103102105"] ='0512';Code["103102106"] ='0513';Code["103102107"] ='0518';Code["103102108"] ='0517';Code["103102109"] ='0515';Code["103102110"] ='0514';Code["103102111"] ='0511';Code["103102112"] ='0523';Code["103102113"] ='0527';
Code["103103101"] ='0571';Code["103103102"] ='0574';Code["103103103"] ='0577';Code["103103104"] ='0575';Code["103103105"] ='0572';Code["103103106"] ='0575';Code["103103107"] ='0579';Code["103103108"] ='0570';Code["103103109"] ='0580';Code["103103110"] ='0576';Code["103103111"] ='0578';
Code["103104101"] ='0551';Code["103104102"] ='0553';Code["103104103"] ='0552';Code["103104104"] ='0554';Code["103104105"] ='0555';Code["103104106"] ='0561';Code["103104107"] ='0562';Code["103104108"] ='0556';Code["103104109"] ='0559';Code["103104110"] ='0550';Code["103104111"] ='0558';Code["103104112"] ='0557';Code["103104113"] ='0565';Code["103104114"] ='0564';Code["103104115"] ='0558';Code["103104116"] ='0566';Code["103104117"] ='0563';
Code["103105101"] ='0591';Code["103105102"] ='0592';Code["103105103"] ='0594';Code["103105104"] ='0598';Code["103105105"] ='0595';Code["103105106"] ='0596';Code["103105107"] ='0599';Code["103105108"] ='0597';Code["103105109"] ='0593';
Code["103106101"] ='0791';Code["103106102"] ='0798';Code["103106103"] ='0799';Code["103106104"] ='0792';Code["103106105"] ='0790';Code["103106106"] ='0701';Code["103106107"] ='0797';Code["103106108"] ='0796';Code["103106109"] ='0795';Code["103106110"] ='0794';Code["103106111"] ='0793';
Code["103107101"] ='0531';Code["103107102"] ='0532';Code["103107103"] ='0533';Code["103107104"] ='0632';Code["103107105"] ='0546';Code["103107106"] ='0535';Code["103107107"] ='0536';Code["103107108"] ='0537';Code["103107109"] ='0538';Code["103107110"] ='0631';Code["103107111"] ='0633';Code["103107112"] ='0634';Code["103107113"] ='0539';Code["103107114"] ='0534';Code["103107115"] ='0635';Code["103107116"] ='0543';Code["103107117"] ='0530';
Code["104101101"] ='0371';Code["104101102"] ='0378';Code["104101103"] ='0379';Code["104101104"] ='0375';Code["104101105"] ='0372';Code["104101106"] ='0392';Code["104101107"] ='0373';Code["104101108"] ='0391';Code["104101109"] ='0393';Code["104101110"] ='0374';Code["104101111"] ='0395';Code["104101112"] ='0398';Code["104101113"] ='0377';Code["104101114"] ='0370';Code["104101115"] ='0376';Code["104101116"] ='0394';Code["104101117"] ='0396';
Code["104102101"] ='027';Code["104102102"] ='0714';Code["104102103"] ='0719';Code["104102105"] ='0717';Code["104102106"] ='0710';Code["104102107"] ='0711';Code["104102108"] ='0724';Code["104102109"] ='0712';Code["104102110"] ='0716';Code["104102111"] ='0713';Code["104102112"] ='0715';Code["104102113"] ='0722';Code["104102128"] ='0718';Code["104102190"] ='0728';
Code["104103101"] ='0731';Code["104103102"] ='0733';Code["104103103"] ='0732';Code["104103104"] ='0734';Code["104103105"] ='0739';Code["104103106"] ='0730';Code["104103107"] ='0736';Code["104103108"] ='0744';Code["104103109"] ='0737';Code["104103110"] ='0735';Code["104103111"] ='0746';Code["104103112"] ='0745';Code["104103113"] ='0738';Code["104103131"] ='0743';
Code["104104101"] ='020';Code["104104102"] ='0751';Code["104104103"] ='0755';Code["104104104"] ='0756';Code["104104105"] ='0754';Code["104104106"] ='0757';Code["104104107"] ='0750';Code["104104108"] ='0759';Code["104104109"] ='0668';Code["104104112"] ='0758';Code["104104113"] ='0752';Code["104104114"] ='0753';Code["104104115"] ='0660';Code["104104116"] ='0762';Code["104104117"] ='0662';Code["104104118"] ='0763';Code["104104119"] ='0769';Code["104104120"] ='0760';Code["104104151"] ='0768';Code["104104152"] ='0663';Code["104104153"] ='0766';
Code["104105101"] ='0771';Code["104105102"] ='0772';Code["104105103"] ='0773';Code["104105104"] ='0774';Code["104105105"] ='0779';Code["104105106"] ='0770';Code["104105107"] ='0777';Code["104105108"] ='0775';Code["104105109"] ='0775';Code["104105110"] ='0776';Code["104105111"] ='0774';Code["104105112"] ='0778';Code["104105113"] ='0772';Code["104105114"] ='0771';
Code["104106101"] ='0898';Code["104106102"] ='0898';Code["104106110"] ='0898';Code["104106111"] ='0898';Code["104106112"] ='0898';Code["104106113"] ='0898';Code["104106114"] ='0898';Code["104106115"] ='0898';Code["104106116"] ='0898';Code["104106117"] ='0898';Code["104106118"] ='0898';Code["104106190"] ='0898';Code["104106191"] ='0898';Code["104106192"] ='0898';Code["104106193"] ='0898';Code["104106194"] ='0898';Code["104106195"] ='0898';Code["104106196"] ='0898';Code["104106197"] ='0898';Code["104106198"] ='0898';Code["104106199"] ='0898';
Code["105100101"] ='023';
Code["105101101"] ='028';Code["105101103"] ='0813';Code["105101104"] ='0812';Code["105101105"] ='0830';Code["105101106"] ='0838';Code["105101107"] ='0816';Code["105101108"] ='0839';Code["105101109"] ='0825';Code["105101110"] ='0832';Code["105101111"] ='0833';Code["105101113"] ='0817';Code["105101114"] ='028';Code["105101115"] ='0831';Code["105101116"] ='0826';Code["105101117"] ='0818';Code["105101118"] ='0835';Code["105101119"] ='0827';Code["105101120"] ='028';Code["105101132"] ='0837';Code["105101133"] ='0836';Code["105101134"] ='0834';
Code["105102101"] ='0851';Code["105102102"] ='0858';Code["105102103"] ='0852';Code["105102104"] ='0853';Code["105102122"] ='0856';Code["105102123"] ='0859';Code["105102124"] ='0857';Code["105102126"] ='0855';Code["105102127"] ='0854';
Code["105103101"] ='0871';Code["105103103"] ='0874';Code["105103104"] ='0877';Code["105103105"] ='0875';Code["105103106"] ='0870';Code["105103107"] ='0888';Code["105103123"] ='0878';Code["105103125"] ='0873';Code["105103126"] ='0876';Code["105103127"] ='0879';Code["105103128"] ='0691';Code["105103129"] ='0872';Code["105103131"] ='0692';Code["105103133"] ='0886';Code["105103134"] ='0887';Code["105103135"] ='0883';
Code["105104101"] ='0891';Code["105104121"] ='0895';Code["105104122"] ='0893';Code["105104123"] ='0892';Code["105104124"] ='0896';Code["105104125"] =' 0897';Code["105104126"] ='0894';
Code["106101101"] ='029';Code["106101102"] ='0919';Code["106101103"] ='0917';Code["106101104"] ='0910';Code["106101105"] ='0913';Code["106101106"] ='0911';Code["106101107"] ='0916';Code["106101108"] ='0912';Code["106101109"] ='0915';Code["106101110"] ='0914';
Code["106102101"] ='0931';Code["106102102"] ='0937';Code["106102103"] ='0935';Code["106102104"] ='0943';Code["106102105"] ='0938';Code["106102106"] ='0935';Code["106102107"] ='0936';Code["106102108"] ='0933';Code["106102109"] ='0937';Code["106102110"] ='0934';Code["106102124"] ='0932';Code["106102126"] ='0939';Code["106102129"] ='0930';Code["106102130"] ='0941';
Code["106103101"] ='0971';Code["106103121"] ='0972';Code["106103122"] ='0970';Code["106103123"] ='0973';Code["106103125"] ='0974';Code["106103126"] ='0975';Code["106103127"] ='0976';Code["106103128"] ='0977';
Code["106104101"] ='0951';Code["106104102"] ='0952';Code["106104103"] ='0953';Code["106104104"] ='0954';
Code["106105101"] ='0991';Code["106105102"] ='0990';Code["106105121"] ='0995';Code["106105122"] ='0902';Code["106105123"] ='0994';Code["106105127"] ='0909';Code["106105128"] ='0996';Code["106105129"] ='0997';Code["106105130"] ='0908';Code["106105131"] ='0998';Code["106105132"] ='0903';Code["106105140"] ='0999';Code["106105142"] ='0901';Code["106105143"] ='0906';Code["106105190"] ='0993';
Code["107101101"] ='00886';
Code["108101101"] ='00853';
Code["109101101"] ='00852';

var County = new Array()
County["101101000"] = new Array('101101000000','')
County["101101101"] = new Array('101101101000','','101101101101','','101101101102','','101101101103','','101101101104','','101101101105','','101101101106','̨','101101101107','ʯɽ','101101101108','','101101101109','ͷ','101101101111','ɽ','101101101112','ͨ','101101101113','˳','101101101114','ƽ','101101101115','','101101101116','','101101101117','ƽ','101101101118','','101101101119','')
County["101102000"] = new Array('101102000000','')
County["101102101"] = new Array('101102101000','','101102101101','ƽ','101102101102','Ӷ','101102101103','','101102101104','Ͽ','101102101105','ӱ','101102101106','','101102101107','','101102101108','','101102101109','','101102101110','','101102101111','','101102101112','','101102101113','','101102101114','','101102101115','','101102101116','','101102101117','','101102101118','')
County["101103000"] = new Array('101103000000','')
County["101103101"] = new Array('101103101000','','101103101102','','101103101103','Ŷ','101103101104','','101103101105','»','101103101107','','101103101108','ԣ','101103101121','','101103101123','','101103101124','','101103101125','','101103101126','','101103101127','','101103101128','','101103101129','޻','101103101130','޼','101103101131','ƽɽ','101103101132','Ԫ','101103101133','','101103101181','','101103101182','޻','101103101183','','101103101184','','101103101185','¹Ȫ')
County["101103102"] = new Array('101103102000','','101103102102','·','101103102103','·','101103102104','ұ','101103102105','ƽ','101103102107','','101103102108','','101103102123','','101103102124','','101103102125','ͤ','101103102127','Ǩ','101103102129','','101103102130','ƺ','101103102181','','101103102183','Ǩ')
County["101103103"] = new Array('101103103000','','101103103102','','101103103103','ɽ','101103103104','','101103103121','','101103103122','','101103103123','','101103103124','¬')
County["101103104"] = new Array('101103104000','','101103104102','ɽ','101103104103','̨','101103104104','','101103104106','','101103104121','','101103104123','','101103104124','ɰ','101103104125','','101103104126','','101103104127','','101103104128','','101103104129','','101103104130','','101103104131','','101103104132','ƽ','101103104133','','101103104134','κ','101103104135','','101103104181','䰲')
County["101103105"] = new Array('101103105000','','101103105102','Ŷ','101103105103','','101103105121','̨','101103105122','ٳ','101103105123','','101103105124','','101103105125','¡Ң','101103105126','','101103105127','Ϻ','101103105128','','101103105129','¹','101103105130','º','101103105131','','101103105132','ƽ','101103105133','','101103105134','','101103105135','','101103105181','Ϲ','101103105182','ɳ')
County["101103106"] = new Array('101103106000','','101103106102','','101103106103','','101103106104','','101103106121','','101103106122','Է','101103106123','ˮ','101103106124','ƽ','101103106125','ˮ','101103106126','','101103106127','','101103106128','','101103106129','ݳ','101103106130','Դ','101103106131','','101103106132','','101103106133','','101103106134','','101103106135','','101103106136','˳ƽ','101103106137','Ұ','101103106138','','101103106181','','101103106182','','101103106183','','101103106184','߱')
County["101103107"] = new Array('101103107000','','101103107102','Ŷ','101103107103','','101103107105','','101103107106','»԰','101103107121','','101103107122','ű','101103107123','','101103107124','Դ','101103107125','','101103107126','ε','101103107127','ԭ','101103107128','','101103107129','ȫ','101103107130','','101103107131','¹','101103107132','','101103107133','')
County["101103108"] = new Array('101103108000','','101103108102','˫','101103108103','˫','101103108104','ӥӪӿ','101103108121','е','101103108122','¡','101103108123','ƽȪ','101103108124','ƽ','101103108125','¡','101103108126','','101103108127','','101103108128','Χɹ')
County["101103109"] = new Array('101103109000','','101103109102','»','101103109103','˺','101103109121','','101103109122','','101103109123','','101103109124','','101103109125','ɽ','101103109126','','101103109127','Ƥ','101103109128','','101103109129','','101103109130','ϴ','101103109181','ͷ','101103109182','','101103109183','','101103109184','Ӽ')
County["101103110"] = new Array('101103110000','','101103110102','','101103110103','','101103110122','̰','101103110123','','101103110124','','101103110125','','101103110126','İ','101103110128','󳧻','101103110181','','101103110182','')
County["101103111"] = new Array('101103111000','','101103111102','ҳ','101103111121','ǿ','101103111122','','101103111123','ǿ','101103111124','','101103111125','ƽ','101103111126','ʳ','101103111127','','101103111128','','101103111181','','101103111182','')
County["101104000"] = new Array('101104000000','')
County["101104101"] = new Array('101104101000','','101104101101','С','101104101102','ӭ','101104101103','ӻ','101104101104','ƺ','101104101105','','101104101106','Դ','101104101107','','101104101108','','101104101109','¦','101104101110','Ž')
County["101104102"] = new Array('101104102000','','101104102101','','101104102102','','101104102103','Ͻ','101104102104','','101104102105','','101104102106','','101104102107','','101104102108','','101104102109','Դ','101104102110','','101104102111','ͬ')
County["101104103"] = new Array('101104103000','','101104103101','','101104103102','','101104103103','','101104103104','ƽ','101104103105','')
County["101104104"] = new Array('101104104000','','101104104101','','101104104102','','101104104103','','101104104104','ԫ','101104104105','','101104104106','ƽ˳','101104104107','','101104104108','','101104104109','','101104104110','','101104104111','','101104104112','Դ','101104104113','º')
County["101104105"] = new Array('101104105000','','101104105101','','101104105102','ˮ','101104105103','','101104105104','괨','101104105105','','101104105106','ƽ')
County["101104106"] = new Array('101104106000','','101104106101','˷','101104106102','ƽ³','101104106103','ɽ','101104106104','Ӧ','101104106105','','101104106106','')
County["101104107"] = new Array('101104107000','','101104107101','ܴ','101104107102','','101104107103','Ȩ','101104107104','˳','101104107105','','101104107106','','101104107107','̫','101104107108','','101104107109','ƽң','101104107110','ʯ','101104107111','')
County["101104108"] = new Array('101104108000','','101104108101','κ','101104108102','','101104108103','','101104108104','ϲ','101104108105','ɽ','101104108106','','101104108107','','101104108108','ԫ','101104108109','','101104108110','ƽ½','101104108111','ǳ','101104108112','','101104108113','ӽ')
County["101104109"] = new Array('101104109000','','101104109101','ø','101104109102','','101104109103','̨','101104109104','','101104109105','','101104109106','','101104109107','','101104109108','','101104109109','կ','101104109110','','101104109111','','101104109112','','101104109113','ƫ','101104109114','ԭƽ')
County["101104110"] = new Array('101104110000','','101104110101','Ң','101104110102','','101104110103','','101104110104','','101104110105','鶴','101104110106','','101104110107','','101104110108','ɽ','101104110109','','101104110110','','101104110111','','101104110112','','101104110113','','101104110114','','101104110115','','101104110116','','101104110117','')
County["101104111"] = new Array('101104111000','','101104111101','Т','101104111102','ʯ','101104111103','','101104111104','ˮ','101104111105','','101104111106','','101104111107','','101104111108','','101104111109','ʯ¥','101104111110','','101104111111','ɽ','101104111112','','101104111113','')
County["101105100"] = new Array('101105100000','')
County["101105101"] = new Array('101105101000','','101105101101','³','101105101102','','101105101103','Ȫ','101105101104','','101105101105','Ĭ','101105101106','п','101105101107','ָ','101105101108','ˮ','101105101109','䴨')
County["101105102"] = new Array('101105102000','','101105102101','','101105102102','','101105102103','ɽ','101105102104','ʯ','101105102105','ƿ','101105102106','ԭ','101105102107','Ĭ','101105102108','','101105102109','ï')
County["101105103"] = new Array('101105103000','','101105103101','','101105103102','','101105103103','ڴ')
County["101105104"] = new Array('101105104000','','101105104101','ɽ','101105104102','Ԫɽ','101105104103','ɽ','101105104104','³ƶ','101105104105','','101105104106','','101105104107','','101105104108','ʲ','101105104109','ţ','101105104110','','101105104111','','101105104112','')
County["101105105"] = new Array('101105105000','','101105105101','ƶ','101105105102','ƶ','101105105103','ƶ','101105105104','³','101105105105','','101105105106','','101105105107','³','101105105108','ֹ')
County["101105106"] = new Array('101105106000','','101105106101','ʤ','101105106102','','101105106103','׼','101105106104','пǰ','101105106105','п','101105106106','','101105106107','','101105106108','')
County["101105107"] = new Array('101105107000','','101105107101','','101105107102','','101105107103','ĪߴӶ','101105107104','״','101105107105','¿','101105107106','°Ͷ','101105107107','°Ͷ','101105107108','°Ͷ','101105107109','','101105107110','ʯ','101105107111','','101105107112','','101105107113','')
County["101105108"] = new Array('101105108000','','101105108101','','101105108102','ɽ','101105108103','ƶǰ','101105108104','ƶ','101105108105','','101105108106','ͻȪ')
County["101105109"] = new Array('101105109000','','101105109101','','101105109102','ֺ','101105109103','͸','101105109104','','101105109105','','101105109106','','101105109107','','101105109108','̫','101105109109','','101105109110','','101105109111','','101105109112','')
County["101105110"] = new Array('101105110000','','101105110101','','101105110102','','101105110103','׿','101105110104','','101105110105','̶','101105110106','˺','101105110107','','101105110108','ǰ','101105110109','','101105110110','','101105110111','')
County["101105111"] = new Array('101105111000','','101105111101','ٺ','101105111102','ԭ','101105111103','','101105111104','ǰ','101105111105','','101105111106','غ','101105111107','')
County["101105112"] = new Array('101105112000','','101105112101','','101105112102','','101105112103','')
County["102101000"] = new Array('102101000000','')
County["102101101"] = new Array('102101101000','','102101101101','ƽ','102101101102','','102101101103','','102101101104','ʹ','102101101105','','102101101106','ռ','102101101107','','102101101108','³','102101101109','ں','102101101110','','102101101111','ƽ','102101101112','','102101101113','')
County["102101102"] = new Array('102101102000','','102101102101','ɽ','102101102102','','102101102103','ɳӿ','102101102104','ʾ','102101102105','˳','102101102106','','102101102107','','102101102108','߷','102101102109','','102101102110','ׯ')
County["102101103"] = new Array('102101103000','','102101103101','','102101103102','','102101103103','ɽ','102101103104','ǧɽ','102101103105','̨','102101103106','','102101103107','')
County["102101104"] = new Array('102101104000','','102101104101','¸','102101104102','','102101104103','','102101104104','˳','102101104105','˳','102101104106','±','102101104107','ԭ')
County["102101105"] = new Array('102101105000','','102101105101','ƽɽ','102101105102','Ϫ','102101105103','ɽ','102101105104','Ϸ','102101105105','Ϫ','102101105106','')
County["102101106"] = new Array('102101106000','','102101106101','Ԫ','102101106102','','102101106103','','102101106104','','102101106105','','102101106106','')
County["102101107"] = new Array('102101107000','','102101107101','','102101107102','','102101107103','̫','102101107104','ɽ','102101107105','','102101107106','躣','102101107107','')
County["102101108"] = new Array('102101108000','','102101108101','վǰ','102101108102','','102101108103','Ȧ','102101108104','ϱ','102101108105','','102101108106','ʯ')
County["102101109"] = new Array('102101109000','','102101109101','','102101109102','','102101109103','̫ƽ','102101109104','','102101109105','ϸ','102101109106','ɹ','102101109107','')
County["102101110"] = new Array('102101110000','','102101110101','','102101110102','ʥ','102101110103','ΰ','102101110104','','102101110105','̫Ӻ','102101110106','','102101110107','')
County["102101112"] = new Array('102101112000','','102101112101','˫̨','102101112102','¡̨','102101112103','','102101112104','ɽ')
County["102101113"] = new Array('102101113000','','102101113101','','102101113102','','102101113103','','102101113104','','102101113105','ͼ','102101113106','ɽ','102101113107','ԭ')
County["102101114"] = new Array('102101114000','','102101114101','˫','102101114102','','102101114103','','102101114104','ƽ','102101114105','ɹ','102101114106','Ʊ','102101114107','Դ')
County["102101115"] = new Array('102101115000','','102101115101','ɽ','102101115102','','102101115103','Ʊ','102101115104','','102101115105','','102101115106','˳')
County["102102000"] = new Array('102102000000','')
County["102102101"] = new Array('102102101000','','102102101101','Ϲ','102102101102','','102102101103','','102102101104','','102102101105','԰','102102101106','˫','102102101107','ũ','102102101108','̨','102102101109','','102102101110','»')
County["102102102"] = new Array('102102102000','','102102102101','','102102102102','̶','102102102103','Ӫ','102102102104','','102102102105','','102102102106','Ժ','102102102107','','102102102108','','102102102109','ʯ')
County["102102103"] = new Array('102102103000','','102102103101','','102102103102','','102102103103','','102102103104','ͨ','102102103105','','102102103106','˫')
County["102102104"] = new Array('102102104000','','102102104101','ɽ','102102104102','','102102104103','','102102104104','')
County["102102105"] = new Array('102102105000','','102102105101','','102102105102','','102102105103','ͨ','102102105104','','102102105105','','102102105106','÷ӿ','102102105107','')
County["102102106"] = new Array('102102106000','','102102106101','˵','102102106102','','102102106103','','102102106104','׳','102102106105','Դ','102102106106','ٽ')
County["102102107"] = new Array('102102107000','','102102107101','','102102107102','ǰ˹ɹ','102102107103','','102102107104','Ǭ','102102107105','')
County["102102108"] = new Array('102102108000','','102102108101','䬱','102102108102','','102102108103','ͨ','102102108104','','102102108105','')
County["102102109"] = new Array('102102109000','','102102109101','Ӽ','102102109102','ͼ','102102109103','ػ','102102109104','','102102109105','','102102109106','','102102109107','','102102109108','ͼ')
County["102103000"] = new Array('102103000000','')
County["102103101"] = new Array('102103101000','','102103101101','','102103101102','ϸ','102103101103','','102103101104','̫ƽ','102103101105','㷻','102103101106','','102103101107','ƽ','102103101108','','102103101109','','102103101110','','102103101111','','102103101112','','102103101113','ľ','102103101114','ͨ','102103101115','','102103101116','','102103101117','˫','102103101118','־','102103101119','峣')
County["102103102"] = new Array('102103102000','','102103102101','ɳ','102103102102','','102103102103','','102103102104','Ϫ','102103102105','','102103102106','ɽ','102103102107','÷˹Ӷ','102103102108','','102103102109','','102103102110','̩','102103102111','','102103102112','ԣ','102103102113','ɽ','102103102114','˶','102103102115','Ȫ','102103102116','ګ')
County["102103103"] = new Array('102103103000','','102103103101','','102103103102','ɽ','102103103103','ε','102103103104','','102103103105','Ӻ','102103103106','ɽ','102103103107','','102103103108','','102103103109','ɽ')
County["102103104"] = new Array('102103104000','','102103104101','','102103104102','ũ','102103104103','ɽ','102103104104','˰','102103104105','ɽ','102103104106','ɽ','102103104107','ܱ','102103104108','')
County["102103105"] = new Array('102103105000','','102103105101','ɽ','102103105102','붫','102103105103','ķ̨','102103105104','ɽ','102103105105','','102103105106','','102103105107','','102103105108','ĺ')
County["102103106"] = new Array('102103106000','','102103106101','ͼ','102103106102','','102103106103','ú·','102103106104','','102103106105','ͬ','102103106106','','102103106107','Դ','102103106108','ֵ','102103106109','Ŷɹ')
County["102103107"] = new Array('102103107000','','102103107101','','102103107102','ϲ','102103107103','Ѻ','102103107104','','102103107105','','102103107106','','102103107107','Ϫ','102103107108','ɽ','102103107109','Ӫ','102103107110','','102103107111','','102103107112','','102103107113','','102103107114','','102103107115','ϸ','102103107116','','102103107117','')
County["102103108"] = new Array('102103108000','','102103108101','','102103108102','','102103108103','ǰ','102103108104','','102103108105','','102103108106','','102103108107','봨','102103108108','ԭ','102103108109','Զ','102103108110','ͬ','102103108111','')
County["102103109"] = new Array('102103109000','','102103109101','','102103109102','ɽ','102103109103','Ӻ','102103109104','')
County["102103110"] = new Array('102103110000','','102103110101','','102103110102','','102103110103','','102103110104','','102103110105','','102103110106','ֿ','102103110107','Һ','102103110108','','102103110109','','102103110110','')
County["102103111"] = new Array('102103111000','','102103111101','','102103111102','۽','102103111103','ѷ','102103111104','','102103111105','','102103111106','')
County["102103112"] = new Array('102103112000','','102103112101','','102103112102','','102103112103','','102103112104','','102103112105','찲','102103112106','ˮ','102103112107','','102103112108','','102103112109','ض','102103112110','')
County["102103113"] = new Array('102103113000','','102103113101','','102103113102','','102103113103','Į')
County["103101100"] = new Array('103101100000','')
County["103101101"] = new Array('103101101000','','103101101101','','103101101102','¬','103101101103','','103101101104','','103101101105','','103101101106','','103101101107','բ','103101101108','','103101101109','','103101101110','','103101101111','ɽ','103101101112','ζ','103101101113','ֶ','103101101114','ɽ','103101101115','ɽ','103101101116','','103101101117','ϻ','103101101118','','103101101119','')
County["103102100"] = new Array('103102100000','')
County["103102101"] = new Array('103102101000','','103102101101','','103102101102','','103102101103','ػ','103102101104','','103102101105','¥','103102101106','¹','103102101107','ֿ','103102101108','ϼ','103102101109','껨̨','103102101110','','103102101111','','103102101112','ˮ','103102101113','ߴ')
County["103102102"] = new Array('103102102000','','103102102101','簲','103102102102','ϳ','103102102103','','103102102104','ɽ','103102102105','ɽ','103102102106','','103102102107','','103102102108','')
County["103102103"] = new Array('103102103000','','103102103101','¥','103102103102','','103102103103','','103102103104','','103102103105','Ȫɽ','103102103106','','103102103107','','103102103108','ͭɽ','103102103109','','103102103110','','103102103111','')
County["103102104"] = new Array('103102104000','','103102104101','','103102104102','¥','103102104103','','103102104104','±','103102104105','','103102104106','','103102104107','̳')
County["103102105"] = new Array('103102105000','','103102105101','','103102105102','ƽ','103102105103','','103102105104','','103102105105','','103102105106','','103102105107','','103102105108','żҸ','103102105109','ɽ','103102105110','⽭','103102105111','̫')
County["103102106"] = new Array('103102106000','','103102106101','紨','103102106102','բ','103102106103','','103102106104','綫','103102106105','','103102106106','','103102106107','ͨ','103102106108','')
County["103102107"] = new Array('103102107000','','103102107101','','103102107102','','103102107103','','103102107104','','103102107105','','103102107106','','103102107107','')
County["103102108"] = new Array('103102108000','','103102108101','','103102108102','','103102108103','','103102108104','','103102108105','ˮ','103102108106','','103102108107','','103102108108','')
County["103102109"] = new Array('103102109000','','103102109101','','103102109102','ˮ','103102109103','','103102109104','','103102109105','','103102109106','','103102109107','ζ','103102109108','̨','103102109109','')
County["103102110"] = new Array('103102110000','','103102110101','','103102110102','','103102110103','ά','103102110104','Ӧ','103102110105','','103102110106','','103102110107','')
County["103102111"] = new Array('103102111000','','103102111101','','103102111102','','103102111103','ͽ','103102111104','','103102111105','','103102111106','')
County["103102112"] = new Array('103102112000','','103102112101','','103102112102','߸','103102112103','˻','103102112104','','103102112105','̩','103102112106','')
County["103102113"] = new Array('103102113000','','103102113101','޳','103102113102','ԥ','103102113103','','103102113104','','103102113105','')
County["103103000"] = new Array('103103000000','')
County["103103101"] = new Array('103103101000','','103103101101','ϳ','103103101102','³','103103101103','','103103101104','','103103101105','','103103101106','','103103101107','ɽ','103103101108','ຼ','103103101109','ͩ®','103103101110','','103103101111','','103103101112','','103103101113','ٰ')
County["103103102"] = new Array('103103102000','','103103102101','','103103102102','','103103102103','','103103102104','','103103102105','','103103102106','۴','103103102107','ɽ','103103102108','','103103102109','Ҧ','103103102110','Ϫ','103103102111','')
County["103103103"] = new Array('103103103000','','103103103101','¹','103103103102','','103103103103','걺','103103103104','ͷ','103103103105','','103103103106','ƽ','103103103107','','103103103108','ĳ','103103103109','̩˳','103103103110','','103103103111','')
County["103103104"] = new Array('103103104000','','103103104101','','103103104102','','103103104103','','103103104104','','103103104105','','103103104106','ƽ','103103104107','ͩ')
County["103103105"] = new Array('103103105000','','103103105101','','103103105102','','103103105103','','103103105104','','103103105105','')
County["103103106"] = new Array('103103106000','','103103106101','Խ','103103106102','','103103106103','²','103103106104','','103103106105','','103103106106','')
County["103103107"] = new Array('103103107000','','103103107101','ĳ','103103107102','','103103107103','','103103107104','ֽ','103103107105','Ͱ','103103107106','Ϫ','103103107107','','103103107108','','103103107109','')
County["103103108"] = new Array('103103108000','','103103108101','³','103103108102','齭','103103108103','ɽ','103103108104','','103103108105','','103103108106','ɽ')
County["103103109"] = new Array('103103109000','','103103109101','','103103109102','','103103109103','ɽ','103103109104','')
County["103103110"] = new Array('103103110000','','103103110101','','103103110102','','103103110103','·','103103110104','','103103110105','','103103110106','̨','103103110107','ɾ','103103110108','','103103110109','ٺ')
County["103103111"] = new Array('103103111000','','103103111101','','103103111102','','103103111103','','103103111104','','103103111105','','103103111106','ƺ','103103111107','Ԫ','103103111108','','103103111109','Ȫ')
County["103104000"] = new Array('103104000000','')
County["103104101"] = new Array('103104101000','','103104101101','','103104101102','®','103104101103','ɽ','103104101104','','103104101105','','103104101106','ʶ','103104101107','')
County["103104102"] = new Array('103104102000','','103104102101','','103104102102','','103104102103','','103104102104','𯽭','103104102105','ߺ','103104102106','','103104102107','')
County["103104103"] = new Array('103104103000','','103104103101','','103104103102','','103104103103','','103104103104','','103104103105','Զ','103104103106','','103104103107','')
County["103104104"] = new Array('103104104000','','103104104101','ͨ','103104104102','','103104104103','лҼ','103104104104','˹ɽ','103104104105','˼','103104104106','̨')
County["103104105"] = new Array('103104105000','','103104105101','ׯ','103104105102','ɽ','103104105103','ɽ','103104105104','Ϳ')
County["103104106"] = new Array('103104106000','','103104106101','ż','103104106102','ɽ','103104106103','ɽ','103104106104','Ϫ')
County["103104107"] = new Array('103104107000','','103104107101','ͭɽ','103104107102','ʨɽ','103104107103','','103104107104','ͭ')
County["103104108"] = new Array('103104108000','','103104108101','ӭ','103104108102','','103104108103','','103104108104','','103104108105','','103104108106','Ǳɽ','103104108107','̫','103104108108','','103104108109','','103104108110','','103104108111','ͩ')
County["103104109"] = new Array('103104109000','','103104109101','Ϫ','103104109102','ɽ','103104109103','','103104109104','','103104109105','','103104109106','','103104109107','')
County["103104110"] = new Array('103104110000','','103104110101','','103104110102','','103104110103','','103104110104','ȫ','103104110105','Զ','103104110106','','103104110107','쳤','103104110108','')
County["103104111"] = new Array('103104111000','','103104111101','','103104111102','򣶫','103104111103','Ȫ','103104111104','Ȫ','103104111105','̫','103104111106','','103104111107','','103104111108','')
County["103104112"] = new Array('103104112000','','103104112101','','103104112102','ɽ','103104112103','','103104112104','','103104112105','')
County["103104113"] = new Array('103104113000','','103104113101','ӳ','103104113102','®','103104113103','Ϊ','103104113104','ɽ','103104113105','')
County["103104114"] = new Array('103104114000','','103104114101','','103104114102','ԣ','103104114103','','103104114104','','103104114105','','103104114106','կ','103104114107','ɽ')
County["103104115"] = new Array('103104115000','','103104115101','۳','103104115102','','103104115103','ɳ','103104115104','')
County["103104116"] = new Array('103104116000','','103104116101','','103104116102','','103104116103','ʯ̨','103104116104','')
County["103104117"] = new Array('103104117000','','103104117101','','103104117102','Ϫ','103104117103','','103104117104','','103104117105','Ϫ','103104117106','캵','103104117107','')
County["103105000"] = new Array('103105000000','')
County["103105101"] = new Array('103105101000','','103105101101','¥','103105101102','̨','103105101103','ɽ','103105101104','β','103105101105','','103105101106','','103105101107','','103105101108','Դ','103105101109','','103105101110','̩','103105101111','ƽ̶','103105101112','','103105101113','')
County["103105102"] = new Array('103105102000','','103105102101','','103105102102','˼','103105102103','谲','103105102104','','103105102105','','103105102106','','103105102107','ͬ')
County["103105103"] = new Array('103105103000','','103105103101','','103105103102','','103105103103','','103105103104','','103105103105','')
County["103105104"] = new Array('103105104000','','103105104101','÷','103105104102','Ԫ','103105104103','Ϫ','103105104104','','103105104105','','103105104106','','103105104107','Ϫ','103105104108','ɳ','103105104109','','103105104110','̩','103105104111','','103105104112','')
County["103105105"] = new Array('103105105000','','103105105101','','103105105102','','103105105103','彭','103105105104','Ȫ','103105105105','ݰ','103105105106','Ϫ','103105105107','','103105105108','»','103105105109','','103105105110','ʯʨ','103105105111','','103105105112','ϰ')
County["103105106"] = new Array('103105106000','','103105106101','ܼ','103105106102','','103105106103','','103105106104','','103105106105','گ','103105106106','̩','103105106107','ɽ','103105106108','Ͼ','103105106109','ƽ','103105106110','','103105106111','')
County["103105107"] = new Array('103105107000','','103105107101','ƽ','103105107102','˳','103105107103','ֳ','103105107104','','103105107105','Ϫ','103105107106','','103105107107','','103105107108','ɽ','103105107109','','103105107110','')
County["103105108"] = new Array('103105108000','','103105108101','','103105108102','͡','103105108103','','103105108104','Ϻ','103105108105','ƽ','103105108106','','103105108107','ƽ')
County["103105109"] = new Array('103105109000','','103105109101','','103105109102','ϼ','103105109103','','103105109104','','103105109105','','103105109106','','103105109107','','103105109108','','103105109109','')
County["103106000"] = new Array('103106000000','')
County["103106101"] = new Array('103106101000','','103106101101','','103106101102','','103106101103','','103106101104','','103106101105','ɽ','103106101106','ϲ','103106101107','½','103106101108','','103106101109','')
County["103106102"] = new Array('103106102000','','103106102101','','103106102102','ɽ','103106102103','','103106102104','ƽ')
County["103106103"] = new Array('103106103000','','103106103101','Դ','103106103102','涫','103106103103','','103106103104','','103106103105','«Ϫ')
County["103106104"] = new Array('103106104000','','103106104101','®ɽ','103106104102','','103106104103','Ž','103106104104','','103106104105','ˮ','103106104106','','103106104107','°','103106104108','','103106104109','','103106104110','','103106104111','','103106104112','')
County["103106105"] = new Array('103106105000','','103106105101','ˮ','103106105102','')
County["103106106"] = new Array('103106106000','','103106106101','º','103106106102','཭','103106106103','Ϫ')
County["103106107"] = new Array('103106107000','','103106107101','¹','103106107102','','103106107103','ŷ','103106107104','','103106107105','','103106107106','','103106107107','Զ','103106107108','','103106107109','','103106107110','ȫ','103106107111','','103106107112','ڶ','103106107113','˹','103106107114','','103106107115','Ѱ','103106107116','ʯ','103106107117','','103106107118','Ͽ')
County["103106108"] = new Array('103106108000','','103106108101','','103106108102','ԭ','103106108103','','103106108104','ˮ','103106108105','Ͽ','103106108106','¸','103106108107','','103106108108','̩','103106108109','촨','103106108110','','103106108111','','103106108112','','103106108113','ɽ')
County["103106109"] = new Array('103106109000','','103106109101','Ԭ','103106109102','','103106109103','','103106109104','ϸ','103106109105','˷','103106109106','','103106109107','ͭ','103106109108','','103106109109','','103106109110','߰')
County["103106110"] = new Array('103106110000','','103106110101','ٴ','103106110102','ϳ','103106110103','质','103106110104','Ϸ','103106110105','','103106110106','ְ','103106110107','˻','103106110108','Ϫ','103106110109','Ϫ','103106110110','','103106110111','')
County["103106111"] = new Array('103106111000','','103106111101','','103106111102','','103106111103','','103106111104','ɽ','103106111105','Ǧɽ','103106111106','','103106111107','߮','103106111108','','103106111109','','103106111110','','103106111111','Դ','103106111112','')
County["103107000"] = new Array('103107000000','')
County["103107101"] = new Array('103107101000','','103107101101','','103107101102','','103107101103','','103107101104','','103107101105','','103107101106','','103107101107','ƽ','103107101108','','103107101109','̺','103107101110','')
County["103107102"] = new Array('103107102000','','103107102101','','103107102102','б','103107102103','ķ','103107102104','Ƶ','103107102105','ɽ','103107102106','','103107102107','','103107102108','','103107102109','ī','103107102110','ƽ','103107102111','','103107102112','')
County["103107103"] = new Array('103107103000','','103107103101','ʹ','103107103102','ŵ','103107103103','ɽ','103107103104','','103107103105','ܴ','103107103106','̨','103107103107','','103107103108','Դ')
County["103107104"] = new Array('103107104000','','103107104101','','103107104102','Ѧ','103107104103','ỳ','103107104104','̨ׯ','103107104105','ɽͤ','103107104106','')
County["103107105"] = new Array('103107105000','','103107105101','Ӫ','103107105102','ӿ','103107105103','','103107105104','','103107105105','')
County["103107106"] = new Array('103107106000','','103107106101','֥','103107106102','ɽ','103107106103','Ĳƽ','103107106104','ɽ','103107106105','','103107106106','','103107106107','','103107106108','','103107106109','','103107106110','Զ','103107106111','ϼ','103107106112','')
County["103107107"] = new Array('103107107000','','103107107101','Ϋ','103107107102','ͤ','103107107103','','103107107104','','103107107105','','103107107106','','103107107107','','103107107108','','103107107109','ٹ','103107107110','','103107107111','','103107107112','')
County["103107108"] = new Array('103107108000','','103107108101','','103107108102','γ','103107108103','΢ɽ','103107108104','̨','103107108105','','103107108106','','103107108107','','103107108108','ˮ','103107108109','ɽ','103107108110','','103107108111','','103107108112','޳')
County["103107109"] = new Array('103107109000','','103107109102','̩ɽ','103107109103','','103107109121','','103107109123','ƽ','103107109182','̩','103107109183','ʳ')
County["103107110"] = new Array('103107110000','','103107110102','','103107110181','ĵ','103107110182','ٳ','103107110183','ɽ')
County["103107111"] = new Array('103107111000','','103107111102','','103107111121','','103107111122','')
County["103107112"] = new Array('103107112000','','103107112102','','103107112103','ֳ')
County["103107113"] = new Array('103107113000','','103107113102','ɽ','103107113111','ׯ','103107113112','Ӷ','103107113121','','103107113122','۰','103107113123','ˮ','103107113124','ɽ','103107113125','','103107113126','ƽ','103107113127','','103107113128','','103107113129','')
County["103107114"] = new Array('103107114000','','103107114102','³','103107114121','','103107114122','','103107114123','','103107114124','','103107114125','','103107114126','ƽԭ','103107114127','Ľ','103107114128','','103107114181','','103107114182','')
County["103107115"] = new Array('103107115000','','103107115102','','103107115121','','103107115122','ݷ','103107115123','ƽ','103107115124','','103107115125','','103107115126','','103107115181','')
County["103107116"] = new Array('103107116000','','103107116102','','103107116121','','103107116122','','103107116123','','103107116124','մ','103107116125','','103107116126','ƽ')
County["103107117"] = new Array('103107117000','','103107117102','ĵ','103107117121','','103107117122','','103107117123','','103107117124','Ұ','103107117125','۩','103107117126','۲','103107117127','','103107117128','')
County["104101000"] = new Array('104101000000','')
County["104101101"] = new Array('104101101000','','104101101102','ԭ','104101101103','','104101101104','ܳǻ','104101101105','ˮ','104101101106','Ͻ','104101101108','ɽ','104101101122','Ĳ','104101101181','','104101101182','','104101101183','','104101101184','֣','104101101185','Ƿ')
County["104101102"] = new Array('104101102000','','104101102102','ͤ','104101102103','˳ӻ','104101102104','¥','104101102105','Ϲ','104101102111','','104101102121','','104101102122','ͨ','104101102123','ξ','104101102124','','104101102125','')
County["104101103"] = new Array('104101103000','','104101103102','ϳ','104101103103','','104101103104','eӻ','104101103105','','104101103106','','104101103107','','104101103122','Ͻ','104101103123','°','104101103124','ﴨ','104101103125','','104101103126','','104101103127','','104101103128','','104101103129','','104101103181','ʦ')
County["104101104"] = new Array('104101104000','','104101104102','»','104101104103','','104101104104','ʯ','104101104111','տ','104101104121','','104101104122','Ҷ','104101104123','³ɽ','104101104125','ۣ','104101104181','','104101104182','')
County["104101105"] = new Array('104101105000','','104101105102','ķ','104101105103','','104101105105','','104101105106','','104101105122','','104101105123','','104101105126','','104101105127','ڻ','104101105181','')
County["104101106"] = new Array('104101106000','','104101106102','ɽ','104101106103','ɽ','104101106111','俱','104101106121','','104101106122','')
County["104101107"] = new Array('104101107000','','104101107102','','104101107103','»','104101107104','վ','104101107111','','104101107121','','104101107124','','104101107125','ԭ','104101107126','ӽ','104101107127','','104101107128','ԫ','104101107181','','104101107182','')
County["104101108"] = new Array('104101108000','','104101108102','','104101108103','վ','104101108104','','104101108111','ɽ','104101108121','','104101108122','','104101108123','','104101108125','','104101108181','Դ','104101108182','','104101108183','')
County["104101109"] = new Array('104101109000','','104101109102','','104101109122','','104101109123','','104101109126','','104101109127','̨ǰ','104101109128','')
County["104101110"] = new Array('104101110000','','104101110102','κ','104101110123','','104101110124','۳','104101110125','','104101110181','','104101110182','')
County["104101111"] = new Array('104101111000','','104101111102','Դ','104101111121','','104101111122','','104101111123','۱')
County["104101112"] = new Array('104101112000','','104101112102','','104101112121','ų','104101112122','','104101112124','¬','104101112181','','104101112182','鱦')
County["104101113"] = new Array('104101113000','','104101113102','','104101113103','','104101113121','','104101113122','','104101113123','Ͽ','104101113124','ƽ','104101113125','','104101113126','','104101113127','','104101113128','ƺ','104101113129','Ұ','104101113130','ͩ','104101113181','')
County["104101114"] = new Array('104101114000','','104101114102','԰','104101114103','','104101114121','Ȩ','104101114122','','104101114123','','104101114124','ϳ','104101114125','ݳ','104101114126','','104101114181','')
County["104101115"] = new Array('104101115000','','104101115102','','104101115103','ƽ','104101115121','ɽ','104101115122','ɽ','104101115123','','104101115124','̳','104101115125','ʼ','104101115126','괨','104101115127','','104101115128','Ϣ')
County["104101116"] = new Array('104101116000','','104101116102','','104101116121','','104101116122','','104101116123','ˮ','104101116124','','104101116125','','104101116126','','104101116127','̫','104101116128','¹','104101116181','')
County["104101117"] = new Array('104101117000','','104101117102','','104101117121','ƽ','104101117122','ϲ','104101117123','ƽ','104101117124','','104101117125','ȷɽ','104101117126','','104101117127','','104101117128','ƽ','104101117129','²')
County["104102000"] = new Array('104102000000','')
County["104102101"] = new Array('104102101000','','104102101102','','104102101103','','104102101104','~','104102101105','','104102101106','','104102101107','ɽ','104102101111','ɽ','104102101112','','104102101113','','104102101114','̵','104102101115','','104102101116','','104102101117','')
County["104102102"] = new Array('104102102000','','104102102102','ʯ','104102102103','ɽ','104102102104','½','104102102105','ɽ','104102102122','','104102102181','ұ')
County["104102103"] = new Array('104102103100','','104102103102','é','104102103103','','104102103121','','104102103122','','104102103123','ɽ','104102103124','Ϫ','104102103125','','104102103181','')
County["104102105"] = new Array('104102105000','','104102105102','','104102105103','Ҹ','104102105104','','104102105105','Vͤ','104102105106','','104102105125','Զ','104102105126','ɽ','104102105127','','104102105128','','104102105129','','104102105181','˶','104102105182','','104102105183','֦')
County["104102106"] = new Array('104102106000','','104102106102','','104102106106','','104102106107','','104102106124','','104102106125','ȳ','104102106126','','104102106182','Ϻӿ','104102106183','','104102106184','˳')
County["104102107"] = new Array('104102107000','','104102107102','Ӻ','104102107103','','104102107104','')
County["104102108"] = new Array('104102108000','','104102108102','','104102108104','޵','104102108121','ɽ','104102108122','ɳ','104102108181','')
County["104102109"] = new Array('104102109000','','104102109102','Т','104102109121','Т','104102109122','','104102109123','','104102109181','Ӧ','104102109182','½','104102109184','')
County["104102110"] = new Array('104102110000','','104102110102','ɳ','104102110103','','104102110122','','104102110123','','104102110124','','104102110181','ʯ','104102110183','','104102110187','')
County["104102111"] = new Array('104102111000','','104102111102','','104102111121','ŷ','104102111122','찲','104102111123','','104102111124','Ӣɽ','104102111125','ˮ','104102111126','ޭ','104102111127','÷','104102111181','','104102111182','Ѩ')
County["104102112"] = new Array('104102112000','','104102112102','̰','104102112121','','104102112122','ͨ','104102112123','','104102112124','ͨɽ','104102112181','')
County["104102113"] = new Array('104102113000','','104102113102','','104102113181','ˮ')
County["104102128"] = new Array('104102128000','','104102128101','ʩ','104102128102','','104102128122','ʼ','104102128123','Ͷ','104102128125','','104102128126','̷','104102128127','','104102128128','׷')
County["104102190"] = new Array('104102190104','','104102190105','Ǳ','104102190106','','104102190121','ũ')
County["104103000"] = new Array('104103000000','')
County["104103101"] = new Array('104103101000','','104103101102','ܽ','104103101103','','104103101104','´','104103101105','','104103101111','껨','104103101121','ɳ','104103101122','','104103101124','','104103101181','')
County["104103102"] = new Array('104103102000','','104103102102','','104103102103','«','104103102104','ʯ','104103102111','Ԫ','104103102121','','104103102123','','104103102124','','104103102125','','104103102181','')
County["104103103"] = new Array('104103103000','','104103103102','','104103103104','','104103103121','̶','104103103181','','104103103182','ɽ')
County["104103104"] = new Array('104103104000','','104103104105','','104103104106','','104103104107','ʯ','104103104108','','104103104112','','104103104121','','104103104122','','104103104123','ɽ','104103104124','ⶫ','104103104126','','104103104181','','104103104182','')
County["104103105"] = new Array('104103105000','','104103105102','˫','104103105103','','104103105111','','104103105121','۶','104103105122','','104103105123','','104103105124','¡','104103105125','','104103105127','','104103105128','','104103105129','ǲ','104103105181','')
County["104103106"] = new Array('104103106000','','104103106102','¥','104103106103','Ϫ','104103106111','ɽ','104103106121','','104103106123','','104103106124','','104103106126','ƽ','104103106181','','104103106182','')
County["104103107"] = new Array('104103107000','','104103107102','','104103107103','','104103107121','','104103107122','','104103107123','','104103107124','','104103107125','Դ','104103107126','ʯ','104103107181','')
County["104103108"] = new Array('104103108000','','104103108102','','104103108111','Դ','104103108121','','104103108122','ɣֲ')
County["104103109"] = new Array('104103109000','','104103109102','','104103109103','ɽ','104103109121','','104103109122','ҽ','104103109123','','104103109181','佭')
County["104103110"] = new Array('104103110000','','104103110102','','104103110103','','104103110121','','104103110122','','104103110123','','104103110124','κ','104103110125','','104103110126','','104103110127','','104103110128','','104103110181','')
County["104103111"] = new Array('104103111000','','104103111102','֥ɽ','104103111103','ˮ̲','104103111121','','104103111122','','104103111123','˫','104103111124','','104103111125','','104103111126','Զ','104103111127','ɽ','104103111128','','104103111129','')
County["104103112"] = new Array('104103112000','','104103112102','׳','104103112121','з','104103112122','','104103112123','Ϫ','104103112124','','104103112125','ͬ','104103112126','','104103112127','»ζ','104103112128','ƽ','104103112129','嶱','104103112130','ͨ','104103112181','齭')
County["104103113"] = new Array('104103113000','','104103113102','¦','104103113121','˫','104103113122','»','104103113181','ˮ','104103113182','Դ')
County["104103131"] = new Array('104103131000','','104103131101','','104103131122','Ϫ','104103131123','','104103131124','ԫ','104103131125','','104103131126','','104103131127','˳','104103131130','ɽ')
County["104104000"] = new Array('104104000000','')
County["104104101"] = new Array('104104101000','','104104101102','ɽ','104104101103','','104104101104','Խ','104104101105','','104104101106','','104104101107','','104104101111','','104104101112','','104104101113','خ','104104101114','','104104101183','','104104101184','ӻ')
County["104104102"] = new Array('104104102000','','104104102102','','104104102103','佭','104104102104','䥽','104104102121','','104104102122','ʼ','104104102124','ʻ','104104102129','Դ','104104102132','Դ','104104102133','·','104104102181','ֲ','104104102182','')
County["104104103"] = new Array('104104103000','','104104103103','޺','104104103104','','104104103105','ɽ','104104103106','','104104103107','','104104103108','','104104103109','ƺɽ')
County["104104104"] = new Array('104104104000','','104104104102','','104104104103','','104104104104','')
County["104104105"] = new Array('104104105000','','104104105106','','104104105107','','104104105108','԰','104104105109','ƽ','104104105110','','104104105123','ϰ','104104105182','','104104105183','κ','104104105184','')
County["104104106"] = new Array('104104106000','','104104106104','','104104106105','Ϻ','104104106106','˳','104104106107','ˮ','104104106108','')
County["104104107"] = new Array('104104107000','','104104107103','','104104107104','','104104107105','»','104104107181','̨ɽ','104104107183','ƽ','104104107184','ɽ','104104107185','ƽ')
County["104104108"] = new Array('104104108000','','104104108102','࿲','104104108103','ϼɽ','104104108104','ͷ','104104108111','','104104108123','Ϫ','104104108125','','104104108181','','104104108182','','104104108183','⴨')
County["104104109"] = new Array('104104109000','','104104109102','ï','104104109103','ï','104104109123','','104104109181','','104104109182','','104104109183','')
County["104104112"] = new Array('104104112000','','104104112102','','104104112103','','104104112123','','104104112124','','104104112125','⿪','104104112126','','104104112183','Ҫ','104104112184','Ļ')
County["104104113"] = new Array('104104113000','','104104113102','ݳ','104104113122','','104104113123','ݶ','104104113124','','104104113181','')
County["104104114"] = new Array('104104114000','','104104114102','÷','104104114121','÷','104104114122','','104104114123','˳','104104114124','廪','104104114126','ƽԶ','104104114127','','104104114181','')
County["104104115"] = new Array('104104115000','','104104115102','','104104115121','','104104115123','½','104104115181','½')
County["104104116"] = new Array('104104116000','','104104116102','Դ','104104116121','Ͻ','104104116122','','104104116123','ƽ','104104116124','ƽ','104104116125','Դ')
County["104104117"] = new Array('104104117000','','104104117102','','104104117121','','104104117123','','104104117181','')
County["104104118"] = new Array('104104118000','','104104118102','','104104118121','','104104118123','ɽ','104104118125','ɽ׳','104104118126','','104104118127','','104104118181','Ӣ','104104118182','')
County["104104119"] = new Array('104104119000','')
County["104104120"] = new Array('104104120000','')
County["104104151"] = new Array('104104151000','','104104151102','','104104151121','','104104151122','ƽ')
County["104104152"] = new Array('104104152000','','104104152102','ų','104104152121','Ҷ','104104152122','','104104152124','','104104152181','')
County["104104153"] = new Array('104104153000','','104104153102','Ƴ','104104153121','','104104153122','','104104153123','ư','104104153181','޶')
County["104105000"] = new Array('104105000000','')
County["104105101"] = new Array('104105101000','','104105101102','','104105101103','³','104105101104','Ǳ','104105101105','','104105101106','','104105101121','','104105101122','','104105101123','¡','104105101124','ɽ','104105101125','','104105101126','','104105101127','')
County["104105102"] = new Array('104105102000','','104105102102','','104105102103','','104105102104','','104105102105','','104105102121','','104105102122','','104105102123','¹կ','104105102124','ڰ','104105102125','ˮ','104105102126','')
County["104105103"] = new Array('104105103000','','104105103102','','104105103103','','104105103104','ɽ','104105103105','','104105103111','ɽ','104105103121','˷','104105103122','ٹ','104105103123','鴨','104105103124','ȫ','104105103125','˰','104105103126','','104105103127','','104105103128','ʤ','104105103129','Դ','104105103130','ƽ','104105103131','','104105103132','')
County["104105104"] = new Array('104105104000','','104105104103','','104105104104','ɽ','104105104111','н','104105104121','','104105104122','','104105104123','ɽ','104105104181','Ϫ')
County["104105105"] = new Array('104105105000','','104105105102','','104105105103','','104105105112','ɽ','104105105121','')
County["104105106"] = new Array('104105106000','','104105106102','ۿ','104105106103','','104105106121','˼','104105106181','')
County["104105107"] = new Array('104105107000','','104105107102','','104105107103','ձ','104105107121','ɽ','104105107122','ֱ')
County["104105108"] = new Array('104105108000','','104105108102','۱','104105108103','','104105108121','ƽ','104105108181','ƽ')
County["104105109"] = new Array('104105109000','','104105109102','','104105109121','','104105109122','½','104105109123','','104105109124','ҵ','104105109181','')
County["104105110"] = new Array('104105110000','','104105110102','ҽ','104105110121','','104105110122','ﶫ','104105110123','ƽ','104105110124','±','104105110125','','104105110126','','104105110127','','104105110128','ҵ','104105110129','','104105110130','','104105110131','¡ָ')
County["104105111"] = new Array('104105111000','','104105111102','˲','104105111121','ƽ','104105111122','ɽ','104105111123','')
County["104105112"] = new Array('104105112000','','104105112102','ǽ','104105112121','ϵ','104105112122','','104105112123','ɽ','104105112124','','104105112125','޳','104105112126','ë','104105112127','','104105112128','','104105112129','','104105112181','')
County["104105113"] = new Array('104105113000','','104105113102','˱','104105113121','ó','104105113122','','104105113123','','104105113124','','104105113181','ɽ')
County["104105114"] = new Array('104105114000','','104105114121','','104105114122','','104105114123','','104105114124','','104105114125','','104105114129','','104105114181','ƾ')
County["104106000"] = new Array('104106000000','')
County["104106101"] = new Array('104106101000','','104106101105','Ӣ','104106101106','','104106101107','ɽ','104106101108','')
County["104106102"] = new Array('104106102000','')
County["104106110"] = new Array('104106110000','')
County["104106111"] = new Array('104106111000','')
County["104106112"] = new Array('104106112000','')
County["104106113"] = new Array('104106113000','')
County["104106114"] = new Array('104106114000','')
County["104106115"] = new Array('104106115000','')
County["104106116"] = new Array('104106116000','')
County["104106117"] = new Array('104106117000','')
County["104106118"] = new Array('104106118000','')
County["104106190"] = new Array('104106190000','')
County["104106191"] = new Array('104106191000','')
County["104106192"] = new Array('104106192000','')
County["104106193"] = new Array('104106193000','')
County["104106194"] = new Array('104106194000','')
County["104106195"] = new Array('104106195000','')
County["104106196"] = new Array('104106196000','')
County["104106197"] = new Array('104106197000','')
County["104106198"] = new Array('104106198000','')
County["104106199"] = new Array('104106199000','')
County["105100000"] = new Array('105100000000','')
County["105100101"] = new Array('105100101000','','105100101101','','105100101102','','105100101103','','105100101104','ɿ','105100101105','','105100101106','ɳƺ','105100101107','','105100101108','ϰ','105100101109','','105100101110','ʢ','105100101111','˫','105100101112','山','105100101113','','105100101114','ǭ','105100101115','','105100101116','뽭','105100101117','','105100101118','ͭ','105100101119','','105100101120','ٲ','105100101121','ɽ','105100101122','ƽ','105100101123','ǿ','105100101124','ᶼ','105100101125','潭','105100101126','¡','105100101127','','105100101128','','105100101129','','105100101130','','105100101131','ɽ','105100101132','Ϫ','105100101133','ʯ','105100101134','ɽ','105100101135','','105100101136','ˮ','105100101137','','105100101138','ϴ','105100101139','','105100101140','ϴ')
County["105101000"] = new Array('105101000000','')
County["105101101"] = new Array('105101101000','','105101101104','','105101101105','','105101101106','ţ','105101101107','','105101101108','ɻ','105101101112','Ȫ','105101101113','׽','105101101114','¶','105101101115','½','105101101121','','105101101122','˫','105101101124','ۯ','105101101129','','105101101131','ѽ','105101101132','½','105101101181','','105101101182','','105101101183','','105101101184','')
County["105101103"] = new Array('105101103000','','105101103102','','105101103103','','105101103104','','105101103111','̲','105101103121','','105101103122','˳')
County["105101104"] = new Array('105101104000','','105101104102','','105101104103','','105101104111','ʺ','105101104121','','105101104122','α')
County["105101105"] = new Array('105101105000','','105101105102','','105101105103','Ϫ','105101105104','̶','105101105121','','105101105122','Ͻ','105101105124','','105101105125','')
County["105101106"] = new Array('105101106000','','105101106103','','105101106123','н','105101106126','޽','105101106181','㺺','105101106182','ʲ','105101106183','')
County["105101107"] = new Array('105101107000','','105101107103','','105101107104','','105101107122','̨','105101107123','ͤ','105101107124','','105101107125','','105101107126','','105101107127','ƽ','105101107181','')
County["105101108"] = new Array('105101108000','','105101108102','','105101108111','Ԫ','105101108112','','105101108121','','105101108122','ന','105101108123','','105101108124','Ϫ')
County["105101109"] = new Array('105101109000','','105101109102','','105101109121','Ϫ','105101109122','','105101109123','Ӣ')
County["105101110"] = new Array('105101110000','','105101110102','','105101110111','','105101110124','Զ','105101110125','','105101110128','¡')
County["105101111"] = new Array('105101111000','','105101111102','','105101111111','ɳ','105101111112','ͨ','105101111113','ں','105101111123','Ϊ','105101111124','','105101111126','н','105101111129','崨','105101111132','','105101111133','','105101111181','üɽ')
County["105101113"] = new Array('105101113000','','105101113102','˳','105101113103','ƺ','105101113104','','105101113121','ϲ','105101113122','Ӫɽ','105101113123','','105101113124','¤','105101113125','','105101113181','')
County["105101114"] = new Array('105101114000','','105101114102','','105101114121','','105101114122','ɽ','105101114123','','105101114124','','105101114125','')
County["105101115"] = new Array('105101115000','','105101115102','','105101115121','˱','105101115122','Ϫ','105101115123','','105101115124','','105101115125','','105101115126','','105101115127','','105101115128','','105101115129','ɽ')
County["105101116"] = new Array('105101116000','','105101116102','㰲','105101116121','','105101116122','ʤ','105101116123','ˮ','105101116181','')
County["105101117"] = new Array('105101117000','','105101117102','ͨ','105101117121','','105101117122','','105101117123','','105101117124','','105101117125','','105101117181','Դ')
County["105101118"] = new Array('105101118000','','105101118102','','105101118121','ɽ','105101118122','','105101118123','Դ','105101118124','ʯ','105101118125','ȫ','105101118126','«ɽ','105101118127','')
County["105101119"] = new Array('105101119000','','105101119102','','105101119121','ͨ','105101119122','Ͻ','105101119123','ƽ')
County["105101120"] = new Array('105101120000','','105101120102','㽭','105101120121','','105101120122','','105101120181','')
County["105101132"] = new Array('105101132000','','105101132121','봨','105101132122','','105101132123','ï','105101132124','','105101132125','կ','105101132126','','105101132127','С','105101132128','ˮ','105101132129','','105101132130','','105101132131','','105101132132','','105101132133','ԭ')
County["105101133"] = new Array('105101133000','','105101133121','','105101133122','','105101133123','','105101133124','','105101133125','Ž','105101133126','','105101133127','¯','105101133128','','105101133129','','105101133130','¸','105101133131','','105101133132','ʯ','105101133133','ɫ','105101133134','','105101133135','','105101133136','','105101133137','','105101133138','')
County["105101134"] = new Array('105101134000','','105101134101','','105101134122','ľ','105101134123','Դ','105101134124','²','105101134125','','105101134126','ᶫ','105101134127','','105101134128','ո','105101134129','','105101134130','','105101134131','Ѿ','105101134132','ϲ','105101134133','','105101134134','Խ','105101134135','','105101134136','','105101134137','ײ')
County["105102000"] = new Array('105102000000','')
County["105102101"] = new Array('105102101000','','105102101102','','105102101103','','105102101111','Ϫ','105102101112','ڵ','105102101113','','105102101114','С','105102101121','','105102101122','Ϣ','105102101123','','105102101181','')
County["105102102"] = new Array('105102102000','','105102102102','ɽ','105102102103','֦','105102102121','ˮ','105102102122','')
County["105102103"] = new Array('105102103000','','105102103102','컨','105102103121','','105102103122','ͩ','105102103123','','105102103124','','105102103125','','105102103126','','105102103127','','105102103128','̶','105102103129','','105102103130','ϰˮ','105102103181','ˮ','105102103182','ʻ')
County["105102104"] = new Array('105102104000','','105102104102','','105102104121','ƽ','105102104122','ն','105102104123','','105102104124','벼','105102104125','岼')
County["105102122"] = new Array('105102122000','','105102122101','ͭ','105102122122','','105102122123','','105102122124','ʯ','105102122125','˼','105102122126','ӡ','105102122127','½','105102122128','غ','105102122129','','105102122130','ɽ')
County["105102123"] = new Array('105102123000','','105102123101','','105102123122','','105102123123','հ','105102123124','¡','105102123125','','105102123126','','105102123127','','105102123128','')
County["105102124"] = new Array('105102124000','','105102124101','Ͻ','105102124122','','105102124123','ǭ','105102124124','ɳ','105102124125','֯','105102124126','Ӻ','105102124127','','105102124128','')
County["105102126"] = new Array('105102126000','','105102126101','','105102126122','ƽ','105102126123','ʩ','105102126124','','105102126125','Զ','105102126126','᯹','105102126127','','105102126128','','105102126129','','105102126130','̨','105102126131','ƽ','105102126132','Ž','105102126133','ӽ','105102126134','ɽ','105102126135','齭','105102126136','կ')
County["105102127"] = new Array('105102127000','','105102127101','','105102127102','Ȫ','105102127122','','105102127123','','105102127125','Ͱ','105102127126','ɽ','105102127127','ƽ','105102127128','޵','105102127129','˳','105102127130','','105102127131','ˮ','105102127132','ˮ')
County["105103000"] = new Array('105103000000','')
County["105103101"] = new Array('105103101000','','105103101102','廪','105103101103','','105103101111','ٶ','105103101112','ɽ','105103101113','','105103101121','ʹ','105103101122','','105103101124','','105103101125','','105103101126','ʯ','105103101127','','105103101128','»Ȱ','105103101129','Ѱ','105103101181','')
County["105103103"] = new Array('105103103000','','105103103102','','105103103121','','105103103122','½','105103103123','ʦ','105103103124','ƽ','105103103125','Դ','105103103126','','105103103128','մ','105103103181','')
County["105103104"] = new Array('105103104000','','105103104102','','105103104121','','105103104122','ν','105103104123','ͨ','105103104124','','105103104125','','105103104126','ɽ','105103104127','ƽ','105103104128','Ԫ')
County["105103105"] = new Array('105103105000','','105103105102','¡','105103105121','ʩ','105103105122','ڳ','105103105123','','105103105124','')
County["105103106"] = new Array('105103106000','','105103106102','','105103106121','³','105103106122','ɼ','105103106123','ν','105103106124','','105103106125','','105103106126','罭','105103106127','','105103106128','','105103106129','','105103106130','ˮ')
County["105103107"] = new Array('105103107000','','105103107102','ų','105103107121','','105103107122','ʤ','105103107123','ƺ','105103107124','')
County["105103123"] = new Array('105103123000','','105103123101','','105103123122','˫','105103123123','Ĳ','105103123124','ϻ','105103123125','Ҧ','105103123126','Ҧ','105103123127','','105103123128','Ԫı','105103123129','䶨','105103123131','»')
County["105103125"] = new Array('105103125000','','105103125101','','105103125102','Զ','105103125122','','105103125123','','105103125124','ˮ','105103125125','ʯ','105103125126','','105103125127','','105103125128','Ԫ','105103125129','','105103125130','ƽ','105103125131','̴','105103125132','ӿ')
County["105103126"] = new Array('105103126000','','105103126121','ɽ','105103126122','ɽ','105103126123','','105103126124','','105103126125','','105103126126','','105103126127','','105103126128','')
County["105103127"] = new Array('105103127000','','105103127101','˼é','105103127122','ն','105103127123','ī','105103127124','','105103127125','ȴ','105103127126','','105103127127','ǹ','105103127128','','105103127129','','105103127130','')
County["105103128"] = new Array('105103128000','','105103128101','','105103128122','º','105103128123','')
County["105103129"] = new Array('105103129000','','105103129101','','105103129122','','105103129123','','105103129124','','105103129125','ֶ','105103129126','Ͻ','105103129127','Ρɽ','105103129128','ƽ','105103129129','','105103129130','Դ','105103129131','','105103129132','')
County["105103131"] = new Array('105103131000','','105103131102','','105103131103','º','105103131122','','105103131123','ӯ','105103131124','¤')
County["105103133"] = new Array('105103133000','','105103133121','ˮ','105103133123','','105103133124','ɽŭ','105103133125','ƺ')
County["105103134"] = new Array('105103134000','','105103134121','','105103134122','','105103134123','ά')
County["105103135"] = new Array('105103135000','','105103135121','ٲ','105103135122','','105103135123','','105103135124','','105103135125','','105103135126','˫岼','105103135127','','105103135128','Դ')
County["105104000"] = new Array('105104000000','')
County["105104101"] = new Array('105104101000','','105104101102','ǹ','105104101121','','105104101122','','105104101123','ľ','105104101124','ˮ','105104101125','','105104101126','','105104101127','ī񹤿')
County["105104121"] = new Array('105104121000','','105104121121','','105104121122','','105104121123','','105104121124','','105104121125','','105104121126','','105104121127','','105104121128','','105104121129','â','105104121132','¡','105104121133','߰')
County["105104122"] = new Array('105104122000','','105104122121','˶','105104122122','','105104122123','','105104122124','ɣ','105104122125','','105104122126','','105104122127','','105104122128','','105104122129','Ӳ','105104122131','¡','105104122132','','105104122133','˿')
County["105104123"] = new Array('105104123000','','105104123101','տ','105104123122','ľ','105104123123','','105104123124','','105104123125','','105104123126','','105104123127','','105104123128','лͨ','105104123129','','105104123130','ʲ','105104123131','','105104123132','','105104123133','ٰ','105104123134','Ƕ','105104123135','¡','105104123136','ľ','105104123137','','105104123138','ڰ')
County["105104124"] = new Array('105104124000','','105104124121','','105104124122','','105104124123','','105104124124','','105104124125','','105104124126','','105104124127','','105104124128','','105104124129','','105104124130','')
County["105104125"] = new Array('105104125000','','105104125121','','105104125122','','105104125123','','105104125124','','105104125125','Ｊ','105104125126','','105104125127','')
County["105104126"] = new Array('105104126000','','105104126121','֥','105104126122','','105104126123','','105104126124','ī','105104126125','','105104126126','','105104126127','')
County["106101000"] = new Array('106101000000','')
County["106101101"] = new Array('106101101000','','106101101102','³','106101101103','','106101101104','','106101101111','','106101101112','δ','106101101113','','106101101114','','106101101115','','106101101116','','106101101122','','106101101124','','106101101125','','106101101126','')
County["106101102"] = new Array('106101102000','','106101102102','','106101102103','ӡ̨','106101102104','ҫ','106101102122','˾')
County["106101103"] = new Array('106101103000','','106101103102','μ','106101103103','̨','106101103121','','106101103122','','106101103123','ɽ','106101103124','','106101103126','ü','106101103127','¤','106101103128','ǧ','106101103129','','106101103130','','106101103131','̫')
County["106101104"] = new Array('106101104100','','106101104102','ض','106101104103','','106101104104','μ','106101104122','ԭ','106101104123','','106101104124','Ǭ','106101104125','Ȫ','106101104126','','106101104127','','106101104128','','106101104129','Ѯ','106101104130','','106101104131','书','106101104181','ƽ')
County["106101105"] = new Array('106101105000','','106101105102','μ','106101105121','','106101105122','','106101105123','','106101105124','','106101105125','γ','106101105126','ѳ','106101105127','ˮ','106101105128','ƽ','106101105181','','106101105182','')
County["106101106"] = new Array('106101106000','','106101106102','','106101106121','ӳ','106101106122','Ӵ','106101106123','ӳ','106101106124','','106101106125','־','106101106126','','106101106127','Ȫ','106101106128','','106101106129','崨','106101106130','˴','106101106131','','106101106132','')
County["106101107"] = new Array('106101107000','','106101107102','̨','106101107121','֣','106101107122','ǹ','106101107123','','106101107124','','106101107125','','106101107126','ǿ','106101107127','','106101107128','','106101107129','','106101107130','ƺ')
County["106101108"] = new Array('106101108000','','106101108102','','106101108121','ľ','106101108122','','106101108123','ɽ','106101108124','','106101108125','','106101108126','','106101108127','֬','106101108128','','106101108129','Ɽ','106101108130','彧','106101108131','')
County["106101109"] = new Array('106101109000','','106101109102','','106101109121','','106101109122','ʯȪ','106101109123','','106101109124','','106101109125','᰸','106101109126','ƽ','106101109127','ƺ','106101109128','Ѯ','106101109129','׺')
County["106101110"] = new Array('106101110000','','106101110102','','106101110121','','106101110122','','106101110123','','106101110124','ɽ','106101110125','','106101110126','ˮ')
County["106102000"] = new Array('106102000000','')
County["106102101"] = new Array('106102101000','','106102101102','ǹ','106102101103','','106102101104','','106102101105','','106102101111','','106102101121','','106102101122','','106102101123','')
County["106102102"] = new Array('106102102000','')
County["106102103"] = new Array('106102103000','','106102103102','','106102103121','')
County["106102104"] = new Array('106102104000','','106102104102','','106102104103','ƽ','106102104121','Զ','106102104122','','106102104123','̩')
County["106102105"] = new Array('106102105000','','106102105102','س','106102105103','','106102105121','ˮ','106102105122','ذ','106102105123','ʹ','106102105124','ɽ','106102105125','żҴ')
County["106102106"] = new Array('106102106000','','106102106102','','106102106121','','106102106122','','106102106123','ף')
County["106102107"] = new Array('106102107000','','106102107102','','106102107121','ԣ','106102107122','','106102107123','','106102107124','̨','106102107125','ɽ')
County["106102108"] = new Array('106102108000','','106102108102','','106102108121','','106102108122','̨','106102108123','','106102108124','ͤ','106102108125','ׯ','106102108126','')
County["106102109"] = new Array('106102109000','','106102109102','','106102109121','','106102109122','','106102109123','౱ɹ','106102109124','','106102109181','','106102109182','ػ')
County["106102110"] = new Array('106102110000','','106102110102','','106102110121','','106102110122','','106102110123','','106102110124','ˮ','106102110125','','106102110126','','106102110127','ԭ')
County["106102124"] = new Array('106102124000','','106102124121','','106102124124','ͨμ','106102124125','¤','106102124126','μԴ','106102124127','','106102124128','','106102124129','')
County["106102126"] = new Array('106102126000','','106102126121','䶼','106102126123','崲','106102126124','','106102126125','','106102126126','','106102126127','','106102126128','','106102126129','','106102126130','')
County["106102129"] = new Array('106102129000','','106102129101','','106102129121','','106102129122','','106102129123','','106102129124','','106102129125','','106102129126','','106102129127','ʯɽ嶫')
County["106102130"] = new Array('106102130000','','106102130101','','106102130121','̶','106102130122','׿','106102130123','','106102130124','','106102130125','','106102130126','µ','106102130127','ĺ')
County["106103000"] = new Array('106103000000','')
County["106103101"] = new Array('106103101000','','106103101102','Ƕ','106103101103','','106103101104','','106103101105','Ǳ','106103101121','ͨ','106103101122','','106103101123','Դ')
County["106103121"] = new Array('106103121000','','106103121121','ƽ','106103121122','ͻ','106103121123','ֶ','106103121126','','106103121127','¡','106103121128','ѭ')
County["106103122"] = new Array('106103122000','','106103122121','Դ','106103122122','','106103122123','','106103122124','ղ')
County["106103123"] = new Array('106103123000','','106103123121','ͬ','106103123122','','106103123123','','106103123124','ɹ')
County["106103125"] = new Array('106103125000','','106103125121','','106103125122','ͬ','106103125123','','106103125124','˺','106103125125','')
County["106103126"] = new Array('106103126000','','106103126121','','106103126122','','106103126123','ʵ','106103126124','','106103126125','','106103126126','')
County["106103127"] = new Array('106103127000','','106103127121','','106103127122','Ӷ','106103127123','ƶ','106103127124','ζ','106103127125','ǫ','106103127126','')
County["106103128"] = new Array('106103128000','','106103128101','ľ','106103128102','','106103128121','','106103128122','','106103128123','')
County["106104000"] = new Array('106104000000','')
County["106104101"] = new Array('106104101000','','106104101104','','106104101105','','106104101106','','106104101121','','106104101122','')
County["106104102"] = new Array('106104102000','','106104102102','','106104102103','ʯɽ','106104102121','ƽ','106104102122','','106104102123','ũ')
County["106104103"] = new Array('106104103000','','106104103102','ͨ','106104103121','','106104103122','','106104103123','γ','106104103124','ͬ','106104103181','ͭϿ','106104103182','')
County["106104104"] = new Array('106104104000','','106104104102','ԭ','106104104121','ԭ','106104104122','','106104104123','¡','106104104124','Դ','106104104125','')
County["106105000"] = new Array('106105000000','')
County["106105101"] = new Array('106105101000','','106105101102','ɽ','106105101103','ɳͿ','106105101104','','106105101105','ˮĥ','106105101106','ͷͺ','106105101107','','106105101108','ɽ','106105101121','³ľ')
County["106105102"] = new Array('106105102000','','106105102102','ɽ','106105102103','','106105102104','׼̲','106105102105','ڶ')
County["106105121"] = new Array('106105121000','','106105121101','³','106105121122','۷','106105121123','пѷ')
County["106105122"] = new Array('106105122000','','106105122101','','106105122122','','106105122123','')
County["106105123"] = new Array('106105123000','','106105123101','','106105123102','','106105123103','Ȫ','106105123123','ͼ','106105123124','˹','106105123125','̨','106105123127','ľ','106105123128','ľݹ')
County["106105127"] = new Array('106105127000','','106105127101','','106105127122','','106105127123','Ȫ')
County["106105128"] = new Array('106105128000','','106105128101','','106105128122','̨','106105128123','ξ','106105128124','Ǽ','106105128125','ĩ','106105128126','Ȼ','106105128127',';','106105128128','˶','106105128129','')
County["106105129"] = new Array('106105129000','','106105129101','','106105129122','','106105129123','⳵','106105129124','ɳ','106105129125','º','106105129126','ݳ','106105129127','ʲ','106105129128','','106105129129','ƺ')
County["106105130"] = new Array('106105130000','','106105130101','ͼʲ','106105130122','','106105130123','','106105130124','ǡ')
County["106105131"] = new Array('106105131000','','106105131101','ʲ','106105131121','踽','106105131122','','106105131123','Ӣɳ','106105131124','','106105131125','ɯ','106105131126','Ҷ','106105131127','','106105131128','պ','106105131129','٤ʦ','106105131130','ͳ','106105131131','ʲ')
County["106105132"] = new Array('106105132000','','106105132101','','106105132121','','106105132122','ī','106105132123','Ƥɽ','106105132124','','106105132125','','106105132126','','106105132127','')
County["106105140"] = new Array('106105140000','','106105140102','','106105140103','','106105140121','','106105140122','첼','106105140123','','106105140124','','106105140125','Դ','106105140126','','106105140127','ؿ˹','106105140128','տ')
County["106105142"] = new Array('106105142000','','106105142101','','106105142102','','106105142121','','106105142123','ɳ','106105142124','','106105142125','ԣ','106105142126','Ͳɹ')
County["106105143"] = new Array('106105143000','','106105143101','̩','106105143121','','106105143122','','106105143123','','106105143124','ͺ','106105143125','','106105143126','ľ')
County["106105190"] = new Array('106105190101','ʯ','106105190102','','106105190103','ͼľ','106105190104','')
County["107101000"] = new Array('107101000000','')
County["107101101"] = new Array('107101101000','')
County["108101101"] = new Array('108101101000','')
County["109101101"] = new Array('109101101000','')